unit testunit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TfrmMain = class(TForm)
    lbUserName: TLabel;
    eUserName: TEdit;
    lbKey: TLabel;
    mKey: TMemo;
    Bevel1: TBevel;
    Bevel2: TBevel;
    lbKeyExpiration: TLabel;
    eKeyExpiration: TEdit;
    btnClose: TButton;
    btnRegister: TButton;
    procedure btnCloseClick(Sender: TObject);
    procedure btnRegisterClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    procedure OnRegistration(Name, Key : string);
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses enigma_ide;

{$R *.dfm}

procedure TfrmMain.btnCloseClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TfrmMain.OnRegistration(Name, Key : string);
var
  wYear, wMonth, wDay : word;
begin
  if EP_RegCheckKey(PChar(Name), PChar(Key)) then
  begin
    if EP_RegKeyExpirationDate(wYear, wMonth, wDay) then
    begin
      eKeyExpiration.Color := clLime;
      eKeyExpiration.Text := format('%.2d/%.2d/%.2d', [wMonth, wDay, wYear]);
    end else
    begin
      eKeyExpiration.Color := clAqua;
      eKeyExpiration.Text := 'KEY IS NOT TIME LIMITED';
    end;
  end;
end;

procedure TfrmMain.btnRegisterClick(Sender: TObject);
begin
  OnRegistration(eUserName.Text, mKey.Text);
end;

procedure TfrmMain.FormShow(Sender: TObject);
var
  pcName, pcKey : PChar;
begin
  if EP_RegLoadKey(pcName, pcKey) then
  begin
    OnRegistration(pcName, pcKey);
  end;
end;

end.
